(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     13164,        314]
NotebookOptionsPosition[     12845,        298]
NotebookOutlinePosition[     13189,        313]
CellTagsIndexPosition[     13146,        310]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x0", "+", 
           RowBox[{"a", " ", "\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}]}], ",", 
          RowBox[{"y0", "+", 
           RowBox[{"b", " ", "\[Rho]", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], "}"}], "+", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "f", "]"}], ",", 
           RowBox[{"Sin", "[", "f", "]"}]}], "}"}], "/", "20"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Black", ",", "Thick"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x0", ",", 
         RowBox[{"t", " ", "y0"}]}], " ", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Black", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t", " ", "x0"}], ",", " ", "y0"}], " ", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Black", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x0", "+", 
          RowBox[{"a", " ", "\[Rho]", " ", 
           RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
         RowBox[{"y0", "+", 
          RowBox[{"b", " ", "\[Rho]", " ", 
           RowBox[{"Sin", "[", "t", "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Black", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x0", "+", 
          RowBox[{"a", " ", "\[Rho]", " ", "t", " ", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], "/", "3"}]}]}], ",", 
         RowBox[{"y0", "+", 
          RowBox[{"b", " ", "\[Rho]", " ", "t", " ", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], "/", "3"}]}]}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Blue", "}"}]}]}], "]"}], ",", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x0", "+", 
          RowBox[{"a", " ", "\[Rho]", " ", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], "/", "3"}]}]}], ",", 
         RowBox[{"y0", "+", 
          RowBox[{"b", " ", "\[Rho]", " ", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], "/", "3"}]}]}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Black", "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", "\[Rho]", " ", "t"}], "+", "x0"}], ",", "y0"}], 
        " ", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Black", ",", "Thick"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "t"}], ")"}], 
         RowBox[{"{", 
          RowBox[{"x0", ",", "y0"}], "}"}]}], "+", 
        RowBox[{"t", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x0", "+", 
            RowBox[{"a", " ", "\[Rho]", " ", 
             RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}]}], ",", 
           RowBox[{"y0", "+", 
            RowBox[{"b", " ", "\[Rho]", " ", 
             RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}]}], "}"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", " ", 
    RowBox[{"\[Rho]", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", " ", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.571431559166321*^9, 3.5714316633102775`*^9}, {
   3.571431700100382*^9, 3.5714318431895657`*^9}, {3.5714318763154607`*^9, 
   3.5714319268883533`*^9}, {3.571431964315494*^9, 3.5714319647075167`*^9}, {
   3.571431994995249*^9, 3.5714320902016945`*^9}, {3.571432140962598*^9, 
   3.571432210218559*^9}, {3.571432259622384*^9, 3.571432270631014*^9}, {
   3.571432304406946*^9, 3.5714323104552917`*^9}, {3.571432357063958*^9, 
   3.571432420653595*^9}, {3.5714324728675814`*^9, 3.5714325172961226`*^9}, {
   3.5714325597745523`*^9, 3.571432604655119*^9}, {3.5714326979334545`*^9, 
   3.57143279996029*^9}, {3.571432837115415*^9, 3.571432837492437*^9}, 
   3.571432870056299*^9, {3.5714329048792915`*^9, 3.5714329086825085`*^9}, {
   3.5714353662450733`*^9, 3.571435366387081*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`b$$ = 
    1, $CellContext`x0$$ = 0, $CellContext`y0$$ = 0, $CellContext`\[Rho]$$ = 
    0, $CellContext`\[CurlyPhi]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x0$$], 0, 2}, {
      Hold[$CellContext`y0$$], 0, 2}, {
      Hold[$CellContext`a$$], 1, 4}, {
      Hold[$CellContext`b$$], 1, 4}, {
      Hold[$CellContext`\[Rho]$$], 0, 8}, {
      Hold[$CellContext`\[CurlyPhi]$$], 0, 2 Pi}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x0$13438$$ = 
    0, $CellContext`y0$13439$$ = 0, $CellContext`a$13440$$ = 
    0, $CellContext`b$13441$$ = 0, $CellContext`\[Rho]$13442$$ = 
    0, $CellContext`\[CurlyPhi]$13443$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 
        1, $CellContext`x0$$ = 0, $CellContext`y0$$ = 
        0, $CellContext`\[Rho]$$ = 0, $CellContext`\[CurlyPhi]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x0$$, $CellContext`x0$13438$$, 0], 
        Hold[$CellContext`y0$$, $CellContext`y0$13439$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$13440$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$13441$$, 0], 
        Hold[$CellContext`\[Rho]$$, $CellContext`\[Rho]$13442$$, 0], 
        Hold[$CellContext`\[CurlyPhi]$$, $CellContext`\[CurlyPhi]$13443$$, 
         0]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        ParametricPlot[{$CellContext`x0$$ + $CellContext`a$$ $CellContext`\
\[Rho]$$ Cos[$CellContext`\[CurlyPhi]$$], $CellContext`y0$$ + \
$CellContext`b$$ $CellContext`\[Rho]$$ Sin[$CellContext`\[CurlyPhi]$$]} + {
            Cos[$CellContext`f], 
            Sin[$CellContext`f]}/20, {$CellContext`f, 0, 2 Pi}, 
         PlotStyle -> {Black, Thick}], 
        ParametricPlot[{$CellContext`x0$$, $CellContext`t $CellContext`y0$$}, \
{$CellContext`t, 0, 1}, PlotStyle -> {Black, Dashed}], 
        ParametricPlot[{$CellContext`t $CellContext`x0$$, $CellContext`y0$$}, \
{$CellContext`t, 0, 1}, PlotStyle -> {Black, Dashed}], 
        ParametricPlot[{$CellContext`x0$$ + $CellContext`a$$ $CellContext`\
\[Rho]$$ Cos[$CellContext`t], $CellContext`y0$$ + $CellContext`b$$ \
$CellContext`\[Rho]$$ Sin[$CellContext`t]}, {$CellContext`t, 0, 2 Pi}, 
         PlotStyle -> {Black, Dashed}], 
        ParametricPlot[{$CellContext`x0$$ + $CellContext`a$$ $CellContext`\
\[Rho]$$ $CellContext`t (Cos[$CellContext`f $CellContext`\[CurlyPhi]$$]/
            3), $CellContext`y0$$ + $CellContext`b$$ $CellContext`\[Rho]$$ \
$CellContext`t (Sin[$CellContext`f $CellContext`\[CurlyPhi]$$]/
            3)}, {$CellContext`t, 0, 1}, {$CellContext`f, 0, 1}, 
         PlotStyle -> {Blue}], 
        ParametricPlot[{$CellContext`x0$$ + $CellContext`a$$ $CellContext`\
\[Rho]$$ (Cos[$CellContext`f $CellContext`\[CurlyPhi]$$]/
            3), $CellContext`y0$$ + $CellContext`b$$ $CellContext`\[Rho]$$ (
            Sin[$CellContext`f $CellContext`\[CurlyPhi]$$]/
            3)}, {$CellContext`f, 0, 1}, PlotStyle -> {Black}], 
        ParametricPlot[{$CellContext`a$$ $CellContext`\[Rho]$$ $CellContext`t + \
$CellContext`x0$$, $CellContext`y0$$}, {$CellContext`t, 0, 1}, 
         PlotStyle -> {Black, Thick}], 
        ParametricPlot[(
           1 - $CellContext`t) {$CellContext`x0$$, $CellContext`y0$$} + \
$CellContext`t {$CellContext`x0$$ + $CellContext`a$$ $CellContext`\[Rho]$$ 
             Cos[$CellContext`\[CurlyPhi]$$], $CellContext`y0$$ + \
$CellContext`b$$ $CellContext`\[Rho]$$ 
             Sin[$CellContext`\[CurlyPhi]$$]}, {$CellContext`t, 0, 1}, 
         PlotStyle -> {Red, Thick}], PlotRange -> {{-8, 8}, {-8, 8}}, 
        AxesOrigin -> {0, 0}], 
      "Specifications" :> {{$CellContext`x0$$, 0, 2}, {$CellContext`y0$$, 0, 
         2}, {$CellContext`a$$, 1, 4}, {$CellContext`b$$, 1, 
         4}, {$CellContext`\[Rho]$$, 0, 8}, {$CellContext`\[CurlyPhi]$$, 0, 2 
         Pi}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{409., {292., 297.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.5714316275202303`*^9, 3.5714316492754745`*^9}, 
   3.571431785604272*^9, 3.5714318447246532`*^9, {3.5714318768054886`*^9, 
   3.5714319275373907`*^9}, 3.5714319653065505`*^9, 3.571432001498621*^9, 
   3.5714320908727326`*^9, 3.5714321529712844`*^9, 3.571432215342852*^9, 
   3.5714322714090586`*^9, {3.5714323076561317`*^9, 3.571432311165333*^9}, 
   3.5714324223546925`*^9, {3.571432504404385*^9, 3.5714325177901506`*^9}, 
   3.57143260570918*^9, {3.571432793298909*^9, 3.5714328006483297`*^9}, {
   3.5714328411546464`*^9, 3.571432871035355*^9}, 3.571432909615562*^9, 
   3.5714353199044228`*^9, 3.571435370995345*^9, 3.5714354404883194`*^9}]
}, Open  ]]
},
WindowSize->{1298, 817},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 6721, 176, 192, "Input"],
Cell[7303, 200, 5526, 95, 606, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
